quietly {
*****************************************************************
**********************DATASET ISTAT (IT-SILC)********************
*****************************************************************
****creation individual identifier (pid) in each SILC cross-section
use "\ISTAT\udb_cit04r_iess.dta", clear
* * rename  rb010 anno
sort  anno rb030_
merge m:m anno rb030_ using "INPS\chiave_anonima.dta"
drop if _merge==2
drop _merge
* * rename  id_individuo pid
save "ISTAT\udb_cit04r_iess.dta", replace
use "ISTAT\udb_cit05r_iess.dta", clear
* * rename  rb010 anno
sort  anno rb030_
merge m:m anno rb030_ using "INPS\chiave_anonima.dta"
drop if _merge==2
drop _merge
* * rename  id_individuo pid
save "ISTAT\udb_cit05r_iess.dta", replace
use "ISTAT\udb_cit06r_iess.dta", clear
* * rename  rb010 anno
sort  anno rb030_
merge m:m anno rb030_ using "INPS\chiave_anonima.dta"
drop if _merge==2
drop _merge
* * rename  id_individuo pid
save "ISTAT\udb_cit06r_iess.dta", replace
use "ISTAT\udb_cit07r_iess.dta", clear
* rename  rb010 anno
sort  anno rb030_
merge m:m anno rb030_ using "INPS\chiave_anonima.dta"
drop if _merge==2
drop _merge
* rename  id_individuo pid
save "ISTAT\udb_cit07r_iess.dta", replace
use "ISTAT\udb_cit08r_iess.dta", clear
* rename  rb010 anno
sort  anno rb030_
merge m:m anno rb030_ using "INPS\chiave_anonima.dta"
drop if _merge==2
drop _merge
* rename  id_individuo pid
save "ISTAT\udb_cit08r_iess.dta", replace
use "ISTAT\udb_cit09r_iess.dta", clear
* rename  rb010 anno
sort  anno rb030_
merge m:m anno rb030_ using "INPS\chiave_anonima.dta"
drop if _merge==2
drop _merge
* rename  id_individuo pid
save "ISTAT\udb_cit09r_iess.dta", replace
use "ISTAT\udb_cit10r_iess.dta", clear
* rename  rb010 anno
sort  anno rb030_
merge m:m anno rb030_ using "INPS\chiave_anonima.dta"
drop if _merge==2
drop _merge
* rename  id_individuo pid
save "ISTAT\udb_cit10r_iess.dta", replace
use "ISTAT\udb_cit11r_iess.dta", clear
* rename  rb010 anno
sort  anno rb030_
merge m:m anno rb030_ using "INPS\chiave_anonima.dta"
drop if _merge==2
drop _merge
* rename  id_individuo pid
save "ISTAT\udb_cit11r_iess.dta", replace
use "ISTAT\udb_cit12r_iess.dta", clear
* rename  rb010 anno
sort  anno rb030_
merge m:m anno rb030_ using "INPS\chiave_anonima.dta"
drop if _merge==2
drop _merge
* rename  id_individuo pid
save "ISTAT\udb_cit12r_iess.dta", replace

}

*************************************************************************************
***EXTRACTING INDIVIDUAL INFORMATION FROM SILC***************************************
*************************************************************************************
quietly {
tempfile ind2004 ind2005 ind2006 ind2007 ind2008 ind2009 ind2010 ind2011 ind2012 ///
		 rel04 rel05 rel06 rel07 rel08 rel09 rel10 rel11 rel12

****************************
use "ISTAT\udb_cit04r_iess.dta", clear

rename rb230_ mother_id
rename rb030_ child_id
rename rb070 child_qbirth
rename rb080 child_ybirth
rename rb090 child_sex
sort mother_id child_ybirth child_qbirth child_sex

keep if mother_id!=.
gen one=1 if mother_id!=.
bys mother_id: gen t=sum(one)

keep anno mother_id child_id child_ybirth child_qbirth child_sex t
tsset mother_id t
xtdes
reshape wide child_id child_ybirth child_qbirth child_sex, i(mother_id) j(t)
aorder

save "`rel04'", replace

use "ISTAT\udb_cit04p_iess.dta", clear
rename pb010 anno
gen mother_id=pb030_
merge m:m anno mother_id using "`rel04'"
tab _merge
drop _merge
drop mother_id

rename  pb030_ rb030_
drop ph*
merge m:m rb030_ using "ISTAT\udb_cit04r_iess.dta"
drop _merge
qui destring *, replace
cap drop py030g_f
cap drop pb090_f
save "`ind2004'"

****************************
use "ISTAT\udb_cit05r_iess.dta", clear

rename rb230_ mother_id
rename rb030_ child_id
rename rb070 child_qbirth
rename rb080 child_ybirth
rename rb090 child_sex
sort mother_id child_ybirth child_qbirth child_sex

keep if mother_id!=.
gen one=1 if mother_id!=.
bys mother_id: gen t=sum(one)

keep anno mother_id child_id child_ybirth child_qbirth child_sex t
tsset mother_id t
xtdes
reshape wide child_id child_ybirth child_qbirth child_sex, i(mother_id) j(t)
aorder

save "`rel05'", replace

use "ISTAT\udb_cit05p_iess.dta", clear
rename pb010 anno
gen mother_id=pb030_
merge m:m anno mother_id using "`rel05'"
tab _merge
drop _merge
drop mother_id

rename  pb030_ rb030_
drop ph*
merge m:m rb030_ using "ISTAT\udb_cit05r_iess.dta"
drop _merge
qui destring *, replace
cap drop py030g_f
cap drop pb090_f
save "`ind2005'"

****************************
use "ISTAT\udb_cit06r_iess.dta", clear

rename rb230_ mother_id
rename rb030_ child_id
rename rb070 child_qbirth
rename rb080 child_ybirth
rename rb090 child_sex
sort mother_id child_ybirth child_qbirth child_sex

keep if mother_id!=.
gen one=1 if mother_id!=.
bys mother_id: gen t=sum(one)

keep anno mother_id child_id child_ybirth child_qbirth child_sex t
tsset mother_id t
xtdes
reshape wide child_id child_ybirth child_qbirth child_sex, i(mother_id) j(t)
aorder

save "`rel06'", replace

use "ISTAT\udb_cit06p_iess.dta", clear
rename pb010 anno
gen mother_id=pb030_
merge m:m anno mother_id using "`rel06'"
tab _merge
drop _merge
drop mother_id

rename  pb030_ rb030_
drop ph*
merge m:m rb030_ using "ISTAT\udb_cit06r_iess.dta"
drop _merge
qui destring *, replace
cap drop py030g_f
cap drop pb090_f
save "`ind2006'"

****************************
use "ISTAT\udb_cit07r_iess.dta", clear

rename rb230_ mother_id
rename rb030_ child_id
rename rb070 child_qbirth
rename rb080 child_ybirth
rename rb090 child_sex
sort mother_id child_ybirth child_qbirth child_sex

keep if mother_id!=.
gen one=1 if mother_id!=.
bys mother_id: gen t=sum(one)

keep anno mother_id child_id child_ybirth child_qbirth child_sex t
tsset mother_id t
xtdes
reshape wide child_id child_ybirth child_qbirth child_sex, i(mother_id) j(t)
aorder

save "`rel07'", replace

use "ISTAT\udb_cit07p_iess.dta", clear
rename pb010 anno
gen mother_id=pb030_
merge m:m anno mother_id using "`rel07'"
tab _merge
drop _merge
drop mother_id

rename  pb030_ rb030_
drop ph*
merge m:m rb030_ using "ISTAT\udb_cit07r_iess.dta"
drop _merge
qui destring *, replace
cap drop py030g_f
cap drop pb090_f
save "`ind2007'"

****************************
use "ISTAT\udb_cit08r_iess.dta", clear

rename rb230_ mother_id
rename rb030_ child_id
rename rb070 child_qbirth
rename rb080 child_ybirth
rename rb090 child_sex
sort mother_id child_ybirth child_qbirth child_sex

keep if mother_id!=.
gen one=1 if mother_id!=.
bys mother_id: gen t=sum(one)

keep anno mother_id child_id child_ybirth child_qbirth child_sex t
tsset mother_id t
xtdes
reshape wide child_id child_ybirth child_qbirth child_sex, i(mother_id) j(t)
aorder

save "`rel08'", replace

use "ISTAT\udb_cit08p_iess.dta", clear
rename pb010 anno
gen mother_id=pb030_
merge m:m anno mother_id using "`rel08'"
tab _merge
drop _merge
drop mother_id

rename  pb030_ rb030_
drop ph*
merge m:m rb030_ using "ISTAT\udb_cit08r_iess.dta"
drop _merge
qui destring *, replace
cap drop py030g_f
cap drop pb090_f
save "`ind2008'"

****************************
use "ISTAT\udb_cit09r_iess.dta", clear

rename rb230_ mother_id
rename rb030_ child_id
rename rb070 child_qbirth
rename rb080 child_ybirth
rename rb090 child_sex
sort mother_id child_ybirth child_qbirth child_sex

keep if mother_id!=.
gen one=1 if mother_id!=.
bys mother_id: gen t=sum(one)

keep anno mother_id child_id child_ybirth child_qbirth child_sex t
tsset mother_id t
xtdes
reshape wide child_id child_ybirth child_qbirth child_sex, i(mother_id) j(t)
aorder

save "`rel09'", replace

use "ISTAT\udb_cit09p_iess.dta", clear
rename pb010 anno
gen mother_id=pb030_
merge m:m anno mother_id using "`rel09'"
tab _merge
drop _merge
drop mother_id

rename  pb030_ rb030_
drop ph*
merge m:m rb030_ using "ISTAT\udb_cit09r_iess.dta"
drop _merge
qui destring *, replace
cap drop py030g_f
cap drop pb090_f
save "`ind2009'"

****************************
use "ISTAT\udb_cit10r_iess.dta", clear

rename rb230_ mother_id
rename rb030_ child_id
rename rb070 child_qbirth
rename rb080 child_ybirth
rename rb090 child_sex
sort mother_id child_ybirth child_qbirth child_sex

keep if mother_id!=.
gen one=1 if mother_id!=.
bys mother_id: gen t=sum(one)

keep anno mother_id child_id child_ybirth child_qbirth child_sex t
tsset mother_id t
xtdes
reshape wide child_id child_ybirth child_qbirth child_sex, i(mother_id) j(t)
aorder

save "`rel10'", replace

use "ISTAT\udb_cit10p_iess.dta", clear
rename pb010 anno
gen mother_id=pb030_
merge m:m anno mother_id using "`rel10'"
tab _merge
drop _merge
drop mother_id

rename  pb030_ rb030_
drop ph*
merge m:m rb030_ using "ISTAT\udb_cit10r_iess.dta"
drop _merge
qui destring *, replace
cap drop py030g_f
cap drop pb090_f
save "`ind2010'"

****************************
use "ISTAT\udb_cit11r_iess.dta", clear

rename rb230_ mother_id
rename rb030_ child_id
rename rb070 child_qbirth
rename rb080 child_ybirth
rename rb090 child_sex
sort mother_id child_ybirth child_qbirth child_sex

keep if mother_id!=.
gen one=1 if mother_id!=.
bys mother_id: gen t=sum(one)

keep anno mother_id child_id child_ybirth child_qbirth child_sex t
tsset mother_id t
xtdes
reshape wide child_id child_ybirth child_qbirth child_sex, i(mother_id) j(t)
aorder

save "`rel11'", replace

use "ISTAT\udb_cit11p_iess.dta", clear
rename pb010 anno
gen mother_id=pb030_
merge m:m anno mother_id using "`rel11'"
tab _merge
drop _merge
drop mother_id

rename  pb030_ rb030_
drop ph*
merge m:m rb030_ using "ISTAT\udb_cit11r_iess.dta"
drop _merge
qui destring *, replace
cap drop py030g_f
cap drop pb090_f
save "`ind2011'"

****************************
use "ISTAT\udb_cit12r_iess.dta", clear

rename rb230_ mother_id
rename rb030_ child_id
rename rb070 child_qbirth
rename rb080 child_ybirth
rename rb090 child_sex
sort mother_id child_ybirth child_qbirth child_sex

keep if mother_id!=.
gen one=1 if mother_id!=.
bys mother_id: gen t=sum(one)

keep anno mother_id child_id child_ybirth child_qbirth child_sex t
tsset mother_id t
xtdes
reshape wide child_id child_ybirth child_qbirth child_sex, i(mother_id) j(t)
aorder

save "`rel12'", replace

use "ISTAT\udb_cit12p_iess.dta", clear
rename pb010 anno
gen mother_id=pb030_
merge m:m anno mother_id using "`rel12'"
tab _merge
drop _merge
drop mother_id

rename  pb030_ rb030_
drop ph*
merge m:m rb030_ using "ISTAT\udb_cit12r_iess.dta"
drop _merge
qui destring *, replace
cap drop py030g_f
cap drop pb090_f
save "`ind2012'"

use "`ind2004'", clear
append using "`ind2005'"
append using "`ind2006'"
append using "`ind2007'"
append using "`ind2008'"
rename pl110 pl110_
rename nace_p nace_p_
append using "`ind2009'"
append using "`ind2010'"
append using "`ind2011'"
rename rcoco_f rcoco_f_
rename ipfab_e_f ipfab_e_f_
append using "`ind2012'"
sort pid anno
}

***correggiamo i 27 casi anomali (stesso codfisc in più individui in istat) sulla base del genere e dell'anno di nascita da inps
sort pid anno rb090
drop if pid==pid[_n+1] & anno==anno[_n+1]

order  pid rb030_ anno rb090 rb080 rb050 rb030_ id_nucleo

keep if anno==2005 | anno==2011
sort pid
***manteniamo ultima obs per ogni individuo (prendiamo qui le time invariant) - 139 obs deleted. -
drop if pid==pid[_n+1]

rename anno anno_silc
label var anno_silc "ultimo anno intervista silc"
compress

save "istat_ind0511.dta", replace

***MERGE WITH INPS DATA INPS ON PROVINCES WHERE THE INDIVIDUAL WAS BORN
import excel "Provincia_nascita.xlsx", sheet("Foglio1") firstrow clear

rename ID_individuo pid
replace  Provincia110_Stato_nascita="La Spezia" if  Provincia110_Stato_nascita=="La-Spezia"
replace  Provincia103_Stato_nascita="La Spezia" if  Provincia103_Stato_nascita=="La-Spezia"
replace  Provincia110_Stato_nascita="Medio Campidano" if  Provincia110_Stato_nascita=="MedioCampidano"
replace  Provincia103_Stato_nascita="Medio Campidano" if  Provincia103_Stato_nascita=="MedioCampidano"
replace  Provincia110_Stato_nascita="Reggio nell'Emilia" if  Provincia110_Stato_nascita=="Reggio-Emilia"
replace  Provincia103_Stato_nascita="Reggio nell'Emilia" if  Provincia103_Stato_nascita=="Reggio-Emilia"
replace  Provincia110_Stato_nascita="Pesaro e Urbino" if  Provincia110_Stato_nascita=="Pesaro-Urbino"
replace  Provincia103_Stato_nascita="Pesaro e Urbino" if  Provincia103_Stato_nascita=="Pesaro-Urbino"
replace  Provincia110_Stato_nascita="Reggio di Calabria" if  Provincia110_Stato_nascita=="Reggio-Calabria"
replace  Provincia103_Stato_nascita="Reggio di Calabria" if  Provincia103_Stato_nascita=="Reggio-Calabria"
replace  Provincia110_Stato_nascita="Vibo Valentia" if  Provincia110_Stato_nascita=="Vibo-Valentia"
replace  Provincia103_Stato_nascita="Vibo Valentia" if  Provincia103_Stato_nascita=="Vibo-Valentia"
replace  Provincia110_Stato_nascita="L'Aquila" if  Provincia110_Stato_nascita=="Aquila"
replace  Provincia103_Stato_nascita="L'Aquila" if  Provincia103_Stato_nascita=="Aquila"
replace  Provincia110_Stato_nascita="Monza e della Brianza" if  Provincia110_Stato_nascita=="MonzaeBrianza"
replace  Provincia110_Stato_nascita="Ascoli Piceno" if  Provincia110_Stato_nascita=="Ascoli-Piceno"
replace  Provincia103_Stato_nascita="Ascoli Piceno" if  Provincia103_Stato_nascita=="Ascoli-Piceno"
replace  Provincia110_Stato_nascita="Forlì-Cesena" if  Provincia110_Stato_nascita=="Forli-Cesena"
replace  Provincia103_Stato_nascita="Forlì-Cesena" if  Provincia103_Stato_nascita=="Forli-Cesena"
replace  Provincia110_Stato_nascita="Verbano-Cusio-Ossola" if  Provincia110_Stato_nascita=="Verbania"
replace  Provincia103_Stato_nascita="Verbano-Cusio-Ossola" if  Provincia103_Stato_nascita=="Verbania"
sort  pid
tempfile provnas
save "provnas", replace

use "istat_ind0511.dta", clear
merge m:m pid using	 "provnas"

keep if _merge==3
drop _merge

cap drop provnas103
gen provnas103=Provincia103_Stato_nascita

replace  Provincia103_Stato_nascita="Peru" if Provincia103_Stato_nascita=="Peru'"

replace provnas103="nue" if Provincia103_Stato_nascita=="Afghanistan" | Provincia103_Stato_nascita=="Albania" | Provincia103_Stato_nascita=="Algeria" | ///
							Provincia103_Stato_nascita=="Angola" | Provincia103_Stato_nascita=="Araba Siriana" | Provincia103_Stato_nascita=="Argentina" | ///
							Provincia103_Stato_nascita=="Armenia" | Provincia103_Stato_nascita=="Australia" | Provincia103_Stato_nascita=="Bahamas" | ///
							Provincia103_Stato_nascita=="Bangladesh" |  Provincia103_Stato_nascita=="Benin" |  Provincia103_Stato_nascita=="Bielorussia" | ///
							Provincia103_Stato_nascita=="Bolivia" |  Provincia103_Stato_nascita=="Bosnia Erzegovina" |  Provincia103_Stato_nascita=="Brasile"
replace provnas103="nue" if Provincia103_Stato_nascita=="Bulgaria" |  Provincia103_Stato_nascita=="Burkina Faso" |  Provincia103_Stato_nascita=="Burundi" | ///
							Provincia103_Stato_nascita=="Cambogia" |  Provincia103_Stato_nascita=="Camerun" |  Provincia103_Stato_nascita=="Canada" | ///
							Provincia103_Stato_nascita=="Capo Verde" |  Provincia103_Stato_nascita=="Cecoslovacchia" |  Provincia103_Stato_nascita=="Cile" | ///
							Provincia103_Stato_nascita=="Cina" |  Provincia103_Stato_nascita=="Cipro" |  Provincia103_Stato_nascita=="Colombia" | ///
							Provincia103_Stato_nascita=="Congo Repubblica Democratica" |  Provincia103_Stato_nascita=="Congo Repubblica Popolare" | ///
							Provincia103_Stato_nascita=="Costa D'Avorio" |  Provincia103_Stato_nascita=="Costarica" |  Provincia103_Stato_nascita=="Croazia" | ///
							Provincia103_Stato_nascita=="Cuba" |  Provincia103_Stato_nascita=="Ecuador" |  Provincia103_Stato_nascita=="Egitto" | ///
							Provincia103_Stato_nascita=="El Salvador" |  Provincia103_Stato_nascita=="Emirati Arabi" |  Provincia103_Stato_nascita=="Eritrea" | ///
							Provincia103_Stato_nascita=="Estonia" |  Provincia103_Stato_nascita=="Etiopia" |  Provincia103_Stato_nascita=="Filippine" | ///
							Provincia103_Stato_nascita=="Formosa" |  Provincia103_Stato_nascita=="Gabon" |  Provincia103_Stato_nascita=="Georgia" | ///
							Provincia103_Stato_nascita=="Ghana" |  Provincia103_Stato_nascita=="Giappone" |  Provincia103_Stato_nascita=="Giordania" | ///
							Provincia103_Stato_nascita=="Guatemala" |  Provincia103_Stato_nascita=="Guinea" |  Provincia103_Stato_nascita=="Guinea Bissau" | ///
							Provincia103_Stato_nascita=="Honduras" |  Provincia103_Stato_nascita=="Hong Kong" | Provincia103_Stato_nascita=="India" | ///
							Provincia103_Stato_nascita=="Indonesia" | Provincia103_Stato_nascita=="Iran" |  Provincia103_Stato_nascita=="Isole Mauritius" | ///
							Provincia103_Stato_nascita=="Israele" |  Provincia103_Stato_nascita=="Iugoslavia" | Provincia103_Stato_nascita=="Kazakistan"
replace provnas103="nue" if Provincia103_Stato_nascita=="Kazakistan Ex Urss" | Provincia103_Stato_nascita=="Kenya" |  Provincia103_Stato_nascita=="Kossovo" | ///
							Provincia103_Stato_nascita=="Kuwait" |  Provincia103_Stato_nascita=="Lettonia" | Provincia103_Stato_nascita=="Libano" | ///
							Provincia103_Stato_nascita=="Liberia" | Provincia103_Stato_nascita=="Libia" |  Provincia103_Stato_nascita=="Liechtenstein" | ///
							Provincia103_Stato_nascita=="Lituania" |  Provincia103_Stato_nascita=="Macedonia" | Provincia103_Stato_nascita=="Madagascar" | ///
							Provincia103_Stato_nascita=="Mali" | Provincia103_Stato_nascita=="Marocco" | Provincia103_Stato_nascita=="Messico" | Provincia103_Stato_nascita=="Moldavia" | ///
							Provincia103_Stato_nascita=="Nepal" |  Provincia103_Stato_nascita=="Nicaragua" | Provincia103_Stato_nascita=="Nigeria" | ///
							Provincia103_Stato_nascita=="Nuova Zelanda" | Provincia103_Stato_nascita=="Pakistan" |  Provincia103_Stato_nascita=="Panama" | ///
							Provincia103_Stato_nascita=="Paraguay" | Provincia103_Stato_nascita=="Peru" | Provincia103_Stato_nascita=="Polonia" | ///
							Provincia103_Stato_nascita=="Repubblica Di Corea" | Provincia103_Stato_nascita=="Repubblica Dominicana" 
replace provnas103="nue" if Provincia103_Stato_nascita=="Romania" | Provincia103_Stato_nascita=="Russia" |  Provincia103_Stato_nascita=="Senegal" | ///
							Provincia103_Stato_nascita=="Serbia" |  Provincia103_Stato_nascita=="Serbia E Montenegro" | Provincia103_Stato_nascita=="Seychelles" | ///
							Provincia103_Stato_nascita=="Sierra Leone" | Provincia103_Stato_nascita=="Singapore" |  Provincia103_Stato_nascita=="Slovacchia" | ///
							Provincia103_Stato_nascita=="Somalia" |  Provincia103_Stato_nascita=="Sri Lanka" | Provincia103_Stato_nascita=="Stati Uniti D'America" | ///
							Provincia103_Stato_nascita=="Sudafrica" | Provincia103_Stato_nascita=="Sudan" |  Provincia103_Stato_nascita=="Tanzania" | ///
							Provincia103_Stato_nascita=="Thailandia" |  Provincia103_Stato_nascita=="Togo" | Provincia103_Stato_nascita=="Trinidad E Tobago" | ///
							Provincia103_Stato_nascita=="Tunisia" | Provincia103_Stato_nascita=="Turchia" |  Provincia103_Stato_nascita=="Ucraina" | /// 
							Provincia103_Stato_nascita=="Uganda" |  Provincia103_Stato_nascita=="Urss" | Provincia103_Stato_nascita=="Uruguay" | ///
							Provincia103_Stato_nascita=="Uzbekistan" | Provincia103_Stato_nascita=="Uzbekistan Ex Urss" |  Provincia103_Stato_nascita=="Venezuela" | ///
							Provincia103_Stato_nascita=="Vietnam" |  Provincia103_Stato_nascita=="Vietnam Del Sud" | Provincia103_Stato_nascita=="Yemen Sud" | ///
							Provincia103_Stato_nascita=="Zambia" 
replace provnas103="ue" if Provincia103_Stato_nascita=="Austria" | Provincia103_Stato_nascita=="Belgio" | Provincia103_Stato_nascita=="Danimarca" | ///
						   Provincia103_Stato_nascita=="Finlandia" | Provincia103_Stato_nascita=="Francia" | Provincia103_Stato_nascita=="Germania" | Provincia103_Stato_nascita=="Gran Bretagna" | ///
						   Provincia103_Stato_nascita=="Grecia" | Provincia103_Stato_nascita=="Irlanda" | Provincia103_Stato_nascita=="Lussemburgo" | ///
						   Provincia103_Stato_nascita=="Malta" | Provincia103_Stato_nascita=="Monaco" |  Provincia103_Stato_nascita=="Norvegia" | ///
						   Provincia103_Stato_nascita=="Paesi Bassi" | Provincia103_Stato_nascita=="Portogallo" | Provincia103_Stato_nascita=="Repubblica Ceca" | ///
						   Provincia103_Stato_nascita=="San Marino" | Provincia103_Stato_nascita=="Slovenia" | Provincia103_Stato_nascita=="Spagna" | ///
						   Provincia103_Stato_nascita=="Svezia" |  Provincia103_Stato_nascita=="Svizzera" |  Provincia103_Stato_nascita=="Ungheria"
						   
cap drop provnas110
gen provnas110=Provincia110_Stato_nascita
replace provnas110="nue" if Provincia110_Stato_nascita=="Afghanistan" | Provincia110_Stato_nascita=="Albania" | Provincia110_Stato_nascita=="Algeria" | ///
							Provincia110_Stato_nascita=="Angola" | Provincia110_Stato_nascita=="Araba Siriana" | Provincia110_Stato_nascita=="Argentina" | ///
							Provincia110_Stato_nascita=="Armenia" | Provincia110_Stato_nascita=="Australia" | Provincia110_Stato_nascita=="Bahamas" | ///
							Provincia110_Stato_nascita=="Bangladesh" |  Provincia110_Stato_nascita=="Benin" |  Provincia110_Stato_nascita=="Bielorussia" | ///
							Provincia110_Stato_nascita=="Bolivia" |  Provincia110_Stato_nascita=="Bosnia Erzegovina" |  Provincia110_Stato_nascita=="Brasile" | ///
							Provincia110_Stato_nascita=="Bulgaria" |  Provincia110_Stato_nascita=="Burkina Faso" |  Provincia110_Stato_nascita=="Burundi" | ///
							Provincia110_Stato_nascita=="Cambogia" |  Provincia110_Stato_nascita=="Camerun" |  Provincia110_Stato_nascita=="Canada" | ///
							Provincia110_Stato_nascita=="Capo Verde" |  Provincia110_Stato_nascita=="Cecoslovacchia" |  Provincia110_Stato_nascita=="Cile" | ///
							Provincia110_Stato_nascita=="Cina" |  Provincia110_Stato_nascita=="Cipro" |  Provincia110_Stato_nascita=="Colombia" | ///
							Provincia110_Stato_nascita=="Congo Repubblica Democratica" |  Provincia110_Stato_nascita=="Congo Repubblica Popolare" 
replace provnas110="nue" if Provincia110_Stato_nascita=="Costa D'Avorio" |  Provincia110_Stato_nascita=="Costarica" |  Provincia110_Stato_nascita=="Croazia"  | ///
							Provincia110_Stato_nascita=="Cuba" |  Provincia110_Stato_nascita=="Ecuador" |  Provincia110_Stato_nascita=="Egitto" | ///
							Provincia110_Stato_nascita=="El Salvador" |  Provincia110_Stato_nascita=="Emirati Arabi" |  Provincia110_Stato_nascita=="Eritrea" | ///
							Provincia110_Stato_nascita=="Estonia" |  Provincia110_Stato_nascita=="Etiopia" |  Provincia110_Stato_nascita=="Filippine" | ///
							Provincia110_Stato_nascita=="Formosa" |  Provincia110_Stato_nascita=="Gabon" |  Provincia110_Stato_nascita=="Georgia" | ///
							Provincia110_Stato_nascita=="Ghana" |  Provincia110_Stato_nascita=="Giappone" |  Provincia110_Stato_nascita=="Giordania" | ///
							Provincia110_Stato_nascita=="Guatemala" |  Provincia110_Stato_nascita=="Guinea" |  Provincia110_Stato_nascita=="Guinea Bissau" | ///
							Provincia110_Stato_nascita=="Honduras" |  Provincia110_Stato_nascita=="Hong Kong" | Provincia110_Stato_nascita=="India" | ///
							Provincia110_Stato_nascita=="Indonesia" | Provincia110_Stato_nascita=="Iran" |  Provincia110_Stato_nascita=="Isole Mauritius" | ///
							Provincia110_Stato_nascita=="Israele" |  Provincia110_Stato_nascita=="Iugoslavia" | Provincia110_Stato_nascita=="Kazakistan" 
replace provnas110="nue" if Provincia110_Stato_nascita=="Kazakistan Ex Urss" | Provincia110_Stato_nascita=="Kenya" |  Provincia110_Stato_nascita=="Kossovo" | ///
							Provincia110_Stato_nascita=="Kuwait" |  Provincia110_Stato_nascita=="Lettonia" | Provincia110_Stato_nascita=="Libano" | ///
							Provincia110_Stato_nascita=="Liberia" | Provincia110_Stato_nascita=="Libia" |  Provincia110_Stato_nascita=="Liechtenstein" | ///
							Provincia110_Stato_nascita=="Lituania" |  Provincia110_Stato_nascita=="Macedonia" | Provincia110_Stato_nascita=="Madagascar" | ///
							Provincia110_Stato_nascita=="Mali" | Provincia110_Stato_nascita=="Marocco" | Provincia110_Stato_nascita=="Messico" | Provincia110_Stato_nascita=="Moldavia" | ///
							Provincia110_Stato_nascita=="Nepal" |  Provincia110_Stato_nascita=="Nicaragua" | Provincia110_Stato_nascita=="Nigeria" | ///
							Provincia110_Stato_nascita=="Nuova Zelanda" | Provincia110_Stato_nascita=="Pakistan" |  Provincia110_Stato_nascita=="Panama" | ///
							Provincia110_Stato_nascita=="Paraguay" | Provincia110_Stato_nascita=="Peru'" | Provincia110_Stato_nascita=="Polonia" | ///
							Provincia110_Stato_nascita=="Repubblica Di Corea" | Provincia110_Stato_nascita=="Repubblica Dominicana" | ///
							Provincia110_Stato_nascita=="Romania" | Provincia110_Stato_nascita=="Russia" |  Provincia110_Stato_nascita=="Senegal" 
replace provnas110="nue" if Provincia110_Stato_nascita=="Serbia" |  Provincia110_Stato_nascita=="Serbia E Montenegro" | Provincia110_Stato_nascita=="Seychelles" | /// 
							Provincia110_Stato_nascita=="Sierra Leone" | Provincia110_Stato_nascita=="Singapore" |  Provincia110_Stato_nascita=="Slovacchia" | ///
							Provincia110_Stato_nascita=="Somalia" |  Provincia110_Stato_nascita=="Sri Lanka" | Provincia110_Stato_nascita=="Stati Uniti D'America" | ///
							Provincia110_Stato_nascita=="Sudafrica" | Provincia110_Stato_nascita=="Sudan" |  Provincia110_Stato_nascita=="Tanzania" | ///
							Provincia110_Stato_nascita=="Thailandia" |  Provincia110_Stato_nascita=="Togo" | Provincia110_Stato_nascita=="Trinidad E Tobago" | ///
							Provincia110_Stato_nascita=="Tunisia" | Provincia110_Stato_nascita=="Turchia" |  Provincia110_Stato_nascita=="Ucraina" | /// 
							Provincia110_Stato_nascita=="Uganda" |  Provincia110_Stato_nascita=="Urss" | Provincia110_Stato_nascita=="Uruguay" | ///
							Provincia110_Stato_nascita=="Uzbekistan" | Provincia110_Stato_nascita=="Uzbekistan Ex Urss" |  Provincia110_Stato_nascita=="Venezuela" | ///
							Provincia110_Stato_nascita=="Vietnam" |  Provincia110_Stato_nascita=="Vietnam Del Sud" | Provincia110_Stato_nascita=="Yemen Sud" | ///
							Provincia110_Stato_nascita=="Zambia" 
							
replace provnas110="ue" if Provincia110_Stato_nascita=="Austria" | Provincia110_Stato_nascita=="Belgio" | Provincia110_Stato_nascita=="Danimarca" | ///
						   Provincia110_Stato_nascita=="Finlandia" | Provincia110_Stato_nascita=="Francia" | Provincia110_Stato_nascita=="Germania" | Provincia110_Stato_nascita=="Gran Bretagna" | ///
						   Provincia110_Stato_nascita=="Grecia" | Provincia110_Stato_nascita=="Irlanda" | Provincia110_Stato_nascita=="Lussemburgo" | ///
						   Provincia110_Stato_nascita=="Malta" | Provincia110_Stato_nascita=="Monaco" |  Provincia110_Stato_nascita=="Norvegia" | ///
						   Provincia110_Stato_nascita=="Paesi Bassi" | Provincia110_Stato_nascita=="Portogallo" | Provincia110_Stato_nascita=="Repubblica Ceca" | ///
						   Provincia110_Stato_nascita=="San Marino" | Provincia110_Stato_nascita=="Slovenia" | Provincia110_Stato_nascita=="Spagna" | ///
						   Provincia110_Stato_nascita=="Svezia" |  Provincia110_Stato_nascita=="Svizzera" |  Provincia110_Stato_nascita=="Ungheria"
drop Provincia110_Stato_nascita Provincia103_Stato_nascita

*Dropping individuals with missing province of birth
drop if provnas103==""

cap drop provnas103b
gen str15 provnas103b = subinstr(provnas103," ","",.)
drop  provnas103
rename provnas103b provnas103

cap drop provnas110b
gen str20 provnas110b = subinstr(provnas110," ","",.)
drop  provnas110
rename provnas110b provnas110

cap drop reg
gen reg=0
replace reg=1 if    provnas103=="Torino"|provnas103=="Vercelli"|provnas103=="Biella"|provnas103=="Novara"| ///
					provnas103=="Cuneo"|provnas103=="Asti"|provnas103=="Alessandria"|provnas103=="Verbania" // Piemonte
replace reg=2 if	provnas103=="Aosta"																		// Valle d'Aosta
replace reg=3 if	provnas103=="Bergamo"|provnas103=="Brescia"|provnas103=="Como"|provnas103=="Cremona"| ///
					provnas103=="Lecco"|provnas103=="Lodi"|provnas103=="Mantova"|provnas103=="Milano"| ///
					provnas103=="Varese"|provnas103=="Sondrio"|provnas103=="Pavia" 							// Lombardia		
replace reg=4 if	provnas103=="Bolzano"|provnas103=="Trento"												// Trentino-Alto Adige
replace reg=5 if	provnas103=="Verona"|provnas103=="Vicenza"|provnas103=="Belluno"|provnas103=="Treviso"|provnas103=="Venezia"| ///
					provnas103=="Padova"|provnas103=="Rovigo" 												// Veneto
replace reg=6 if	provnas103=="Gorizia"|provnas103=="Pordenone"|provnas103=="Udine"|provnas103=="Trieste"	// Friuli-Venezia Giulia
replace reg=7 if	provnas103=="Genova"|provnas103=="Imperia"|provnas103=="La-Spezia"|provnas103=="Savona"	// Liguria
replace reg=8 if	provnas103=="Piacenza" | provnas103=="Parma" | provnas103=="Reggio-Emilia" | provnas103=="Modena" | ///
					provnas103=="Bologna" | provnas103=="Ferrara" | provnas103=="Ravenna" | ///
					provnas103=="Forli-Cesena" | provnas103=="Rimini"	// Emilia-Romagna
replace reg=9 if	provnas103=="Arezzo"|provnas103=="Firenze"|provnas103=="Grosseto"|provnas103=="Livorno"|provnas103=="Lucca"| ///
					provnas103=="Massa-Carrara"|provnas103=="Pistoia"|provnas103=="Pisa"|provnas103=="Prato"|provnas103=="Siena" // Toscana	
replace reg=10 if	provnas103=="Perugia"|provnas103=="Terni"											// Umbria
replace reg=11 if	provnas103=="Ancona"|provnas103=="Ascoli-Piceno"|provnas103=="Macerata"|provnas103=="Pesaro-Urbino" // Marche
replace reg=12 if	provnas103=="Viterbo"|provnas103=="Rieti"|provnas103=="Roma"|provnas103=="Frosinone"|provnas103=="Latina"	// Lazio
replace reg=13 if	provnas103=="Aquila"|provnas103=="Chieti"|provnas103=="Teramo"|provnas103=="Pescara"	// Abruzzo
replace reg=14 if	provnas103=="Campobasso"|provnas103=="Isernia"										// Molise
replace reg=15 if	provnas103=="Avellino"|provnas103=="Benevento"| provnas103=="Caserta"|provnas103=="Napoli"|provnas103=="Salerno" // Campania
replace reg=16 if	provnas103=="Bari"| provnas103=="Brindisi"|provnas103=="Foggia"|provnas103=="Lecce"|provnas103=="Taranto"	// Puglia
replace reg=17 if	provnas103=="Matera"|provnas103=="Potenza" 										// Basilicata
replace reg=18 if	provnas103=="Catanzaro"|provnas103=="Cosenza"|provnas103=="Crotone"|provnas103=="Vibo-Valentia"|provnas103=="Reggio-Calabria" // Calabria
replace reg=19 if	provnas103=="Trapani"|provnas103=="Palermo"|provnas103=="Agrigento"|provnas103=="Caltanissetta"|provnas103=="Catania"| ///
					provnas103=="Ragusa"|provnas103=="Siracusa"|provnas103=="Enna"|provnas103=="Messina"  		// Sicilia
replace reg=20 if	provnas103=="Cagliari"|provnas103=="Sassari"|provnas103=="Nuoro"|provnas103=="Oristano"|provnas103=="Olbia-Tempio"| ///
					provnas103=="Ogliastra"|provnas103=="Medio Campidano"|provnas103=="Carbonia-Iglesias" 		// Sardegna
replace reg=21 if provnas103=="ue"
replace reg=22 if provnas103=="nue" 

gen age=anno-rb080
gen aedu=pe030-rb080

forvalues k = 1 (1) 11 {
gen kid`k'=0
replace kid`k'=1 if child_id`k'!=.
}
egen nkids=rowtotal(kid1-kid11)

*drop if born abroad (we cannot assign a value to the regional variables to model fertility after school)
drop if reg==21 | reg==22

count

* Keep only WOMEN from 2005 or 2011 waves AND if educational degree obtained from 1977 up to the year before the interview AND
* between 26-45 years of age at the moment of the interview AND who ARE NOT in education at the moment of the interview (PE010==2)
count if (anno_silc==2005 & pe030>1976 & pe030<=2002 & pe010==2 & rb090==2 & age>=26 & age<=45) | ///
         (anno_silc==2011 & pe030>1976 & pe030<=2008 & pe010==2 & rb090==2 & age>=26 & age<=45)

		 		 
keep if (anno_silc==2005 & pe030>1976 & pe030<=2002 & pe010==2 & rb090==2 & age>=26 & age<=45) | ///
         (anno_silc==2011 & pe030>1976 & pe030<=2008 & pe010==2 & rb090==2 & age>=26 & age<=45)
count
*drop women who ended studies before 13 and those who end studies after 32 years, in order to have a more homogeneous sample (they are likely outliers)

keep if aedu>12 & aedu<33

count
*drop women with more than 3 kids at the interview date, in order to have a more homogeneous sample (they are likely outliers)
drop if nkids>3
count

forvalues k = 1 (1) 3 {
cap drop age_birth`k'
gen age_birth`k'=child_ybirth`k'-rb080
}

aorder
drop child_ybirth4-child_ybirth11 kid1-kid11 child_id4-child_id11 child_qbirth4-child_qbirth11 child_sex4-child_sex11
*drop women who had kids before educational level
count
drop if age_birth1<=aedu
count

*MERGING WITH REGIONAL AGGREGATE DATA ON GDP, FERTILITY AND LABOUR MARKET STATE
merge m:1 reg pe030 using "reg_year77.dta" 
drop if _merge==2
drop _merge
drop a9pagam-adira_e afgiur alloggio-anf aperd_e-cerlav cig-ndom nocerco-oralav a1pagam-a7pagam pa010-pass_e pl020-plav_e pmacc-prod_dl ///
	 pb020 rb090 pb150-pb180_f pb220* pc* pd* pe010* pe020* pensit peraum perdim perlav pint_un-piulav ps* pvol-q1630g ///
	 rb020 rb031 rcig-redpre relpar-ytdisog pb050* pb060* pb070* pb080* pb210* rb090*
rename dgdp_one_year dgdp
compress

save "istat_ind0511.dta", replace
